/*
  Analog Input III - Protosnap example

  Turn on the red, green and blue components of the RGB LED based on
  how much light is falling on the light sensor.

  In addition, output the sensor value to the serial console.

  This code is in the public domain.
 */

int sensorPin = A0;  // light sensor input pin
int sensorValue = 0; // variable to store the value coming from the sensor

void setup() {
  pinMode(5, OUTPUT);
  pinMode(6, OUTPUT);
  pinMode(3, OUTPUT);

  // Initiate the serial line
  Serial.begin(9600);
}

void loop() {
  // read the value from the sensor:
  sensorValue = analogRead(sensorPin);

  // print the sensor value to the serial line
  Serial.println(sensorValue);

  // turn the green LED on
  if(sensorValue < 90) {
    digitalWrite(5, LOW);
  } else{
    digitalWrite(5, HIGH);
  }

  // turn the blue LED on
  if(sensorValue < 50) {
    digitalWrite(6, LOW);
  } else{
    digitalWrite(6, HIGH);
  }

  // turn the red LED on
  if(sensorValue < 10) {
    digitalWrite(3, LOW);
  } else{
    digitalWrite(3, HIGH);
  }

  // Add a short delay so we can read the
  // individual numbers as they scroll by
  delay(100);

}
