/*
  Alarm - Protosnap example

  A modal alarm with various states of being set or triggered.

  This example code is in the public domain.
 */

/* variable for current mode:
 *  0 = disarmed
 *  1 = ready to be armed
 *  2 = armed
 *  3 = alarm'd
 */
int mode = 0;

// generic counter that counts times through the loop
unsigned int counter = 0;

int red = 3; // red LED
int grn = 5; // green LED
int blu = 6; // blue LED

// the threshold at which the alarm will be triggered
int alarm_thresh = 30;

// the threshold below which the alarm will armed
int set_thresh = 10;

void setup() {
  pinMode(red, OUTPUT);
  pinMode(grn, OUTPUT);
  pinMode(blu, OUTPUT);
  pinMode(7, INPUT);

  // turn off all the LEDs
  digitalWrite(red, HIGH);
  digitalWrite(grn, HIGH);
  digitalWrite(blu, HIGH);

  // enable pull up resistor on the button
  digitalWrite(7, HIGH);

  // Serial debugger
  Serial.begin(9600);
}

void loop() {

  switch(mode) {

    // disarmed; wait for a button press
    case 0:
      if(LOW == digitalRead(7))
        mode++;
      else
        delay(10);

      if(0 == counter % 250) {
        // flash the blue light
        digitalWrite(blu, LOW);
        delay(100);
        digitalWrite(blu, HIGH);
      }
      break;

    // arm when it gets dark
    case 1:
      digitalWrite(grn, LOW); // turn the green LED on
      if(analogRead(0) <= set_thresh) { // if it gets dark, arm thyself
        mode++;
        delay(1000);
      }
      break;

    // armed! alarm if it gets light
    case 2:
      digitalWrite(grn, HIGH); // turn the green LED off

      if(0 == counter % 1000) {
        // flash the red LED
        digitalWrite(red, LOW);
        delay(100);
        digitalWrite(red, HIGH);
      } else {
        delay(10);
      }

      if(analogRead(0) > alarm_thresh) // It's light! ALARM!!
        mode++;

      break;

    case 3:
      if(LOW == digitalRead(7)) { // reset on button press
        digitalWrite(grn, LOW);
        delay(100);
        digitalWrite(grn, HIGH);
        delay(100);
        digitalWrite(grn, LOW);
        delay(100);
        digitalWrite(grn, HIGH);
        delay(2000);
        mode = 0;
      } else {
        digitalWrite(red, LOW);
        tone(2, 3000);
        delay(500);
        digitalWrite(red, HIGH);
        noTone(2);
        delay(500);
      }
      break;

  }
  // increment the counter
  counter++;
}
