class GoodGuy {

  int mySize = 50;
  int x = 100; // Good guy x position
  int y = 250; // Good guy y position

  float health = 100; // health variable
  float shield = 100; // shield variable

  boolean shieldOn; // shield on variable

  int shipOrient;

  int crashCount;

  GoodGuy() {
    // empty constructor
  }

  void draw() {
    imageMode(CENTER);
    if (shipOrient == 1) {
      image(ship, x, y, mySize, mySize);
    }
    else if (shipOrient == 2) {
      image(shipUp, x, y, mySize, mySize);
    }
    else if (shipOrient == 0) {
      image(shipDown, x, y, mySize, mySize);
    }


    imageMode(CORNER);

    if (shieldOn) {
      ellipseMode(CENTER);
      int shieldAlpha = int(map(shield, 0, 100, 0, 255));
      fill(0, 0, 255, shieldAlpha); // color and alpha of shield
      ellipse(x, y, 60, 60); // draw shield
      ellipseMode(CORNER);
    }
  }

  void move(int dir) {
    y += dir;

    if (dir < -2) {
      shipOrient = 0;
    }
    else if (dir > 2) {
      shipOrient = 2;
    }
    else {
      shipOrient = 1;
    }


    // bound checking
    if (y > height - 50)
      y = height - 50;

    if (y < 50)
      y = 50;
  }

  void shieldActivate() {
    if (shield >= 1) { // make sure we've got shield to use

      shieldOn = true; // if not depleted, turn shield on
      shield -= .1; // decrement shield meter

      // take first actions
      if (! shieldOn) {
        usbPort.write('S'); // communicate to arduino good guy is using shield
        println("Using Shield");
      }
    } 
    else {
      // we're out of shield!
      shieldOn = false;
      usbPort.write('N'); // communicate no shield
    }
  }

  void shieldOff() {
    if (shieldOn) {
      usbPort.write('O'); // communicate to arduino good guy is using shield
      shieldOn = false;
    }
  }
}

