// serial library
import processing.serial.*;
Serial usbPort;

// array to hold sensor readings from the arduino
int [] sensors = null;

// keep track of when we first get data from the arduino
boolean firstContact = false;

//check to see if user has started game
boolean gameOn = false;

int lightValue = 0;  // sensors[0] value (photoresistor on Arduino)
int buttonValue = 1; // sensors[1] value (button on Arduino)
int maxLightVal;     // calibration

float millisCounter; // for further sensor calibration
int buttonCounter;   // for further sensor calibration
boolean buttonFlag;  // for further sensor calibration

float level = 1; // level variable

int direction = 0; // direction: positive is up, negative is down

int numObs = 0; // number of obstacles
Obstacle[] obs = new Obstacle[1000]; // array of obstacles
GoodGuy gg = new GoodGuy();

//images for skin
PImage ast01;
PImage ast02;
PImage ast03;
PImage ast04;
PImage ast05;
PImage ast06;
PImage ship;
PImage shipUp;
PImage shipDown;
PImage crash;
PImage backImage;

float imagePlacer = 0;
int score;

void setup() {
  int numObs = 1; // initialize number of obstacles
  fill(0, 0, 0);
  size (500, 500);
  smooth();

  usbPort = new Serial (this, Serial.list( ) [0], 9600);
  usbPort.bufferUntil ('\n');

  gg.health = 100; // start with full health
  obs[0] = new Obstacle(width + 50, height + 50, 1);

  // try to keep a 30fps frame rate
  frameRate(30);

  ast01 = loadImage ("purple asteroid01.png");
  ast02 = loadImage ("purple asteroid02.png");
  ast03 = loadImage ("green asteroid01.png");
  ast04 = loadImage ("purple asteroid03.png");
  ast05 = loadImage ("green asteroid02.png");
  ast06 = loadImage ("green asteroid03.png");
  ship = loadImage ("ship.png");
  shipUp = loadImage ("shiptilt01.png");
  shipDown = loadImage ("shiptilt02.png");
  crash = loadImage ("crash.png");
  backImage = loadImage ("backgroundimpact.png");
}

// the main draw loop
void draw() {
  if (imagePlacer == -500) {
    imagePlacer = 0;
  }
  if (false == gameOn) {
    menu();
    return;
  }
  // if we get past the above if block, we're playing the game

  fill (0, 0, 0);
  rect (0, 0, width, height);
  image (backImage, imagePlacer, 0, width, height); // draw the starry background twice
  image (backImage, imagePlacer+500, 0, width, height);


  // if we're using the light sensor (not the keyboard)
  if (firstContact) {

    /* if (lightValue > maxLightVal/4 && lightValue < maxLightVal- (maxLightVal/4)){
     direction = 0;
     }
     // current version
     else if (lightValue <= maxLightVal/4) {
     direction = 5;
     
     } 
     else if (lightValue >= maxLightVal - (maxLightVal/4)) {
     direction = -5;
     }
     */
    // first iteration
    // be sure to comment the "gg.move(direction);" line below
    /*
    gg.y = int (map(lightValue, 0, 150, height - 75, 50)); // map sensor value to game screen size
     */

    // light-based speed using calibrated max

    direction = int( map(lightValue, 0, maxLightVal, -5, 5) ); // map sensor value to game screen size


    // light-based speed using theoretical max
    /*
    direction = int( map(lightValue, 0, 1023, -10, 10) ); // map sensor value to game screen size
     */
  }

  // set Good Guy position based on direction
  gg.move(direction);

  // draw the good guy
  gg.draw();


  if (firstContact) {
    if (buttonValue == 0) { // check to see if button pressed

      if (buttonFlag == false) { // check to see if it is a distinct button press
        buttonCounter++; // increment button counter
        buttonFlag = true;
      }
      if (buttonCounter == 1) { // if it is first button press set counter
        millisCounter = millis();//
      }
      if (buttonCounter >=3 && millis() - millisCounter <= 3000) { // check counter and number of presses
        maxLightVal = lightValue; // reset sensor calibration variable
        println("light sensor recalibrated");
      }

      gg.shieldActivate(); // go to shieldActivate function
    } 
    else {
      // button is not pressed
      gg.shieldOff(); // go to shieldActivate function
      buttonFlag = false; // needed for sensor calibration
    }
  }

  if (millis() - millisCounter > 1500) { // if button timer times out
    buttonCounter = 0; // reset buttonCounter
  }

  // randomly add an obstacle (frequency based on level)
  if (random(100) <= (level)) {
    if (numObs==999) { // don't make it too hard now :)
      numObs = 0;
    }
    numObs++;
    obs[numObs] = new Obstacle(width, int(random(50, width + 50)), int(random (6.5)));
  }

  if (numObs>0) {
    for (int i = 1; i<=numObs; i++) {
      obs[i].obstaCall();
    }
  }

  // draw the bounding box, life meter, etc...
  gameTab();

  // set the level based on current level and shield
  level = levelCheck(level, gg.shield);
  imagePlacer--;
}

void serialEvent ( Serial usbPort ) {
  String usbString = usbPort.readStringUntil ('\n');
  if (usbString != null) {
    // get rid of extraneous whitespace
    usbString = trim(usbString);

    int sensors[ ] = int( split(usbString, ',') );

    // we've now made contact
    firstContact = true;

    // set friendly named variables
    lightValue = sensors[0];
    buttonValue = sensors[1];
  }
}

// Handle keypresses for ProtoSnap-less game
void keyPressed() {
  if (key == CODED) {
    if (keyCode == UP) {
      direction = -5;
    } 
    else if (keyCode == DOWN) {
      direction = 5;
    }
  } 
  else if (' ' == key && !firstContact) {
    // press space to start
    gameOn = true;
  } 
  else if ('s' == key) {
    gg.shieldActivate(); // go to shieldActivate function
  }
}

void keyReleased() {
  if (key == CODED) {
    direction = 0;
  } 
  else if ('s' == key) {
    gg.shieldOff();
  }
}

